#!/bin/bash

#Disable SELinux
if [ -s /etc/selinux/config ] && grep 'SELINUX=enforcing' /etc/selinux/config; then
    sed -i 's/SELINUX=enforcing/SELINUX=disabled/g' /etc/selinux/config
    setenforce 0
fi

# 停止firewalld
systemctl stop firewalld.service
# 禁止firewalld服务开机启动
systemctl disable firewalld.service



yum install gcc git patch  cmake make cmake unzip zlib zlib-devel openssl openssl-devel ncurses-devel gcc gcc-c++  wget  pcre pcre-devel -y

tar -zxvf  nginx-1.24.0.tar.gz
tar -zxvf  ngx_http_proxy_connect_module.tar.gz

cd $PWD/nginx-1.24.0
patch -p1 < $PWD/../ngx_http_proxy_connect_module/patch/proxy_connect_rewrite_102101.patch

#添加用户和组
groupadd www
useradd -g www www

./configure --prefix=/usr/local/nginx --add-module=$PWD/../ngx_http_proxy_connect_module --user=www --group=www --with-http_ssl_module --with-http_stub_status_module --with-http_realip_module --with-threads 
make && make install


cp ../nginx /etc/init.d/ -v

chmod a+x /etc/init.d/nginx

chkconfig --add /etc/init.d/nginx
chkconfig nginx on
# 启动
systemctl start nginx

mv -v /usr/local/nginx/conf/nginx.conf /usr/local/nginx/conf/nginx.conf.bak
cp -v ../nginx.conf /usr/local/nginx/conf/nginx.conf
/usr/local/nginx/sbin/nginx -s reload
# 将以下配置写入 /etc/sysctl.conf

cat <<EOF >/etc/sysctl.conf
net.ipv4.tcp_fin_timeout = 5
net.ipv4.tcp_keepalive_time = 5
net.ipv4.tcp_syncookies = 1
net.ipv4.tcp_tw_reuse = 1
net.ipv4.tcp_tw_recycle = 1
net.ipv4.tcp_max_syn_backlog = 3240000
net.ipv4.tcp_max_tw_buckets = 10000

net.ipv4.tcp_mem = 768432 2097152 15242880
net.ipv4.tcp_rmem = 4096 4096 33554432
net.ipv4.tcp_wmem = 4096 4096 33554432
net.ipv4.ip_local_port_range = 2048 64500
net.core.wmem_default = 183888608
net.core.rmem_default = 183888608
net.core.rmem_max = 33554432
net.core.wmem_max = 33554432
net.core.netdev_max_backlog = 2621244

kernel.sem=250 65536 100 2048
kernel.msgmax = 65536
kernel.msgmnb = 65536
kernel.perf_cpu_time_max_percent = 60
kernel.perf_event_max_sample_rate = 6250
net.ipv4.tcp_max_orphans = 1048576
kernel.sched_migration_cost_ns = 5000000
net.core.optmem_max = 25165824
net.core.somaxconn = 60000
net.ipv4.tcp_window_scaling = 1
EOF

# 应用新的配置
sysctl -p && echo "应用系统优化策略成功" || echo "部分系统优化策略应用失败"
